<?php $__env->startSection('title', 'Application Installation'); ?>

<?php $__env->startSection('content'); ?>
    <section class="mt-4">
        <div class="container">
            <form action="<?php echo e(route('install_check')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Type</th>
                                        <th>Extension</th>
                                        <th>Status</th>
                                        <th>Current Version</th>
                                        <th>Required Version</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $requirements['requirements']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $requirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $__currentLoopData = $requirements['requirements'][$type]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extension => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e(Str::upper($type)); ?></td>
                                                <td><?php echo e($extension); ?></td>
                                                <td>
                                                    <span class="badge text-bg-<?php echo e($enabled ? 'success' : 'danger'); ?>">
                                                        <?php echo e($enabled ? 'success' : 'error'); ?>

                                                        <i
                                                            class="bi bi-<?php echo e($enabled ? 'bi bi-check-circle' : 'x-circle'); ?>"></i>
                                                    </span>
                                                </td>
                                                <td>version <?php echo e($phpSupportInfo['current']); ?>

                                                    <i
                                                        class="text-<?php echo e($phpSupportInfo['supported'] ? 'success' : 'danger'); ?> bi bi-<?php echo e($phpSupportInfo['supported'] ? 'check-circle-fill' : 'x-circle-fill'); ?>"></i>
                                                </td>
                                                <td>(version <?php echo e($phpSupportInfo['minimum']); ?> required)</td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>


                <div class="card mb-3">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Folder</th>
                                        <th>Status</th>
                                        <th>Permission</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $permissions['permissions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($permission['folder']); ?></td>
                                            <td>
                                                <span class="badge text-bg-<?php echo $permission['isSet'] ? 'success' : 'danger'; ?>">
                                                    <?php echo $permission['isSet'] ? 'success' : 'error'; ?>

                                                    <i
                                                        class="bi bi-<?php echo e($permission['isSet'] ? 'bi bi-check-circle' : 'x-circle'); ?>"></i>
                                                </span>
                                            </td>
                                            <td><?php echo e($permission['permission']); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?php if(!isset($requirements['errors']) && $phpSupportInfo['supported']): ?>
                    <?php if(!isset($permissions['errors'])): ?>
                        <div class="card-footer footerHome text-end">
                            <div class="d-flex">
                                <button type="submit" id="next_button" class="btn btn-primary ms-auto">Next</button>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('vendor.InstallerEragViews.app-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yippvslhxp/cards.jaaftek.com/resources/views/vendor/InstallerEragViews/index.blade.php ENDPATH**/ ?>