<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.subscription.upgrade_plan')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card subscription">
            <div class="card-body">
                <div class="d-flex flex-column">
                    <div class="nav-group mx-auto">
                        <ul class="nav nav-pills">
                            <?php if($monthlyPlans->isNotEmpty()): ?>
                                <li class="nav-item">
                                    <a data-bs-toggle="tab" href="#monthly" class="nav-link active">
                                        <?php echo e(__('messages.plan.monthly')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if($yearlyPlans->isNotEmpty()): ?>
                                <li class="nav-item">
                                    <a data-bs-toggle="tab" href="#yearly"
                                        class="nav-link <?php echo e($monthlyPlans->isNotEmpty() ? '' : 'active'); ?>">
                                        <?php echo e(__('messages.plan.yearly')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if($unLimitedPlans->isNotEmpty()): ?>
                                <li class="nav-item">
                                    <a data-bs-toggle="tab" href="#unlimited"
                                        class="nav-link <?php echo e($monthlyPlans->isNotEmpty() || $yearlyPlans->isNotEmpty() ? '' : 'active'); ?>">
                                        <?php echo e(__('messages.plan.unlimited')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <?php
                        $activeTab = '';
                        if ($monthlyPlans->isNotEmpty()) {
                            $activeTab = 'monthly';
                        } elseif ($yearlyPlans->isNotEmpty()) {
                            $activeTab = 'yearly';
                        } elseif ($unLimitedPlans->isNotEmpty()) {
                            $activeTab = 'unlimited';
                        }
                    ?>
                    <div class="col-12 text-gray-700 h5 text-center pt-10">
                        <div class="tab-content">
                            <?php if($monthlyPlans->isNotEmpty()): ?>
                                <div class="tab-pane <?php echo e($activeTab == 'monthly' ? 'show active' : ''); ?>" id="monthly">
                                    <div class="row justify-content-center">
                                        <?php $__empty_1 = true; $__currentLoopData = $monthlyPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <?php
                                                if (
                                                    $plan->custom_select == 1 &&
                                                    $plan->planCustomFields->isNotEmpty()
                                                ) {
                                                    $plan->price = $plan->planCustomFields[0]->custom_vcard_price;
                                                }
                                            ?>
                                            <div class="col-xl-4 col-lg-5 col-md-5 col-sm-6">
                                                <div class="card pricing-card bg-light p-5 shadow-lg mb-8">
                                                    <h1><?php echo $plan->name; ?></h1>
                                                    <?php if($plan->custom_select == 1 && $plan->planCustomFields->isNotEmpty()): ?>
                                                        <h1 class="pricing-amount" id="priceDisplay">
                                                            <span
                                                                id="currentPrice-<?php echo e($plan->id); ?>"><?php echo e(currencyFormat($plan->planCustomFields[0]->custom_vcard_price, 2, $plan->currency->currency_code)); ?></span>
                                                        </h1>
                                                    <?php else: ?>
                                                        <h1 class="pricing-amount">
                                                            <?php echo e(currencyFormat($plan->price, 2, $plan->currency->currency_code)); ?>

                                                        </h1>
                                                    <?php endif; ?>
                                                    <div class="card-body ps-3 pe-3 pb-0 pt-1 ">
                                                        <?php if($plan->trial_days > 0): ?>
                                                            <div class="d-flex justify-content-between">
                                                                <small class="text-muted"
                                                                    <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 30px" <?php endif; ?>>
                                                                    <?php echo e(__('messages.subscription.trial_plan') . ' (' . $plan->trial_days . ' ' . __('messages.plan.days') . ')'); ?>

                                                                </small>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="card-body p-3 ">
                                                        <div class="pricing-description text-start">
                                                            <div
                                                                class="mb-3 <?php echo e($plan->custom_select == '1' && $plan->planCustomFields->isNotEmpty() ? '' : 'pb-5'); ?>">
                                                                <?php if($plan->custom_select == 1 && $plan->planCustomFields->isNotEmpty()): ?>
                                                                    <div class="d-flex justify-content-between mb-4">
                                                                        <small class="text-muted"
                                                                            <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 30px" <?php endif; ?>>
                                                                            <?php echo e(__('messages.plan.no_of_vcard_templates')); ?>

                                                                        </small>
                                                                        <select id="vcardNumberSelect-<?php echo e($plan->id); ?>"
                                                                            class="form-select vcard-numbers"
                                                                            style="width: auto;"
                                                                            data-plan-id="<?php echo e($plan->id); ?>">
                                                                            <?php $__currentLoopData = $plan->planCustomFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <?php
                                                                                    $formattedPrice = currencyFormat(
                                                                                        $customField->custom_vcard_price,
                                                                                        2,
                                                                                        $plan->currency->currency_code,
                                                                                    );
                                                                                ?>
                                                                                <option value="<?php echo e($customField->id); ?>"
                                                                                    data-price="<?php echo e($formattedPrice); ?>"
                                                                                    data-currency="<?php echo e($plan->currency->currency_code); ?>">
                                                                                    <?php echo e($customField->custom_vcard_number); ?>

                                                                                </option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    </div>
                                                                <?php else: ?>
                                                                    <small class="text-muted"
                                                                        <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 290px" <?php endif; ?>>
                                                                        <?php echo e(__('messages.plan.no_of_vcard_templates') . ' : ' . $plan->no_of_vcards); ?></small>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="mb-6">
                                                                <small class="text-muted"
                                                                    <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 320px" <?php endif; ?>>
                                                                    <?php echo e(__('messages.plan.storage_limit') . ' : ' . $plan->storage_limit . ' MB'); ?></small>
                                                            </div>
                                                            <?php $__currentLoopData = getPlanFeature($plan); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="d-flex justify-content-between mb-4">
                                                                    <p class="fw-normal">
                                                                        <?php echo e(__('messages.feature.' . $feature)); ?>

                                                                    </p>
                                                                    <?php if($value): ?>
                                                                        <i class="fa-solid fa-circle-check fs-2"></i>
                                                                    <?php else: ?>
                                                                        <i class="fa-solid fa-circle-xmark fs-2"></i>
                                                                    <?php endif; ?>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                    <div class="flex-center flex-row-fluid pt-5">
                                                        <?php if(
                                                            !empty(getCurrentSubscription()) &&
                                                                $plan->id == getCurrentSubscription()->plan_id &&
                                                                !getCurrentSubscription()->isExpired()): ?>
                                                            <?php if($plan->price != 0 || (($plan->price == 0 || $plan->price != 0) && $plan->trial_days > 0)): ?>
                                                                <button type="button"
                                                                    class="btn btn-success rounded-pill mx-auto d-block cursor-remove-plan pricing-plan-button-active"
                                                                    data-id="<?php echo e($plan->id); ?>">
                                                                    <?php echo e(__('messages.subscription.currently_active')); ?></button>
                                                            <?php else: ?>
                                                                <button type="button"
                                                                    class="btn btn-info rounded-pill mx-auto d-block cursor-remove-plan">
                                                                    <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                </button>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <?php if(
                                                                !empty(getCurrentSubscription()) &&
                                                                    !getCurrentSubscription()->isExpired() &&
                                                                    ($plan->price == 0 || $plan->price != 0)): ?>
                                                                <?php if($plan->hasZeroPlan->count() == 0 && ($plan->price > 0 || $plan->trial_days > 0)): ?>
                                                                    <a data-turbo="false"
                                                                        href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                        class="btn btn-primary rounded-pill mx-auto <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                        id="planId<?php echo e($plan->id); ?>"
                                                                        data-id="<?php echo e($plan->id); ?>"
                                                                        data-plan-price="<?php echo e($plan->price); ?>">
                                                                        <?php echo e(__('messages.subscription.switch_plan')); ?></a>
                                                                <?php else: ?>
                                                                    <?php if($plan->price == 0 && $plan->trial_days > 0): ?>
                                                                        <a data-turbo="false"
                                                                            href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                            class="btn btn-primary rounded-pill mx-auto <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                            id="planId<?php echo e($plan->id); ?>"
                                                                            data-id="<?php echo e($plan->id); ?>"
                                                                            data-plan-price="<?php echo e($plan->price); ?>">
                                                                            <?php echo e(__('messages.subscription.switch_plan')); ?></a>
                                                                    <?php else: ?>
                                                                        <button type="button"
                                                                            class="btn btn-info rounded-pill mx-auto d-block cursor-remove-plan">
                                                                            <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                        </button>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php else: ?>
                                                                <?php if(($plan->price != 0 && $plan->hasZeroPlan->count() == 0) || ($plan->price == 0 && $plan->trial_days > 0)): ?>
                                                                    <a data-turbo="false"
                                                                        href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                        class="btn btn-primary rounded-pill mx-auto  <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                        id="planId<?php echo e($plan->id); ?>"
                                                                        data-id="<?php echo e($plan->id); ?>"
                                                                        data-plan-price="<?php echo e($plan->price); ?>">
                                                                        <?php echo e(__('messages.subscription.choose_plan')); ?></a>
                                                                <?php else: ?>
                                                                    <button type="button"
                                                                        class="btn btn-info rounded-pill mx-auto d-block cursor-remove-plan">
                                                                        <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                    </button>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="not-plan">
                                                <span
                                                    class="text-muted h1"><?php echo e(__('messages.subscription.no_plan_available')); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if($yearlyPlans->isNotEmpty()): ?>
                                <div class="tab-pane <?php echo e($activeTab == 'yearly' ? 'show active' : ''); ?>" id="yearly">
                                    <div class="row justify-content-center">
                                        <?php $__empty_1 = true; $__currentLoopData = $yearlyPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <?php
                                                if (
                                                    $plan->custom_select == 1 &&
                                                    $plan->planCustomFields->isNotEmpty()
                                                ) {
                                                    $plan->price = $plan->planCustomFields[0]->custom_vcard_price;
                                                }
                                            ?>
                                            <div class="col-xl-4 col-lg-5 col-md-5 col-sm-6">
                                                <div class="card pricing-card bg-light p-5 shadow-lg mb-8">
                                                    <h1><?php echo $plan->name; ?></h1>
                                                    <?php if($plan->custom_select == 1 && $plan->planCustomFields->isNotEmpty()): ?>
                                                        <h1 class="pricing-amount priceDisplayclass" id="priceDisplay">
                                                            <span
                                                                id="currentPrice-<?php echo e($plan->id); ?>"><?php echo e(currencyFormat($plan->planCustomFields[0]->custom_vcard_price, 2, $plan->currency->currency_code)); ?></span>
                                                        </h1>
                                                    <?php else: ?>
                                                        <h1 class="pricing-amount">
                                                            <?php echo e(currencyFormat($plan->price, 2, $plan->currency->currency_code)); ?>

                                                        </h1>
                                                    <?php endif; ?>
                                                    <div class="card-body ps-3 pe-3 pb-0 pt-1 ">
                                                        <?php if($plan->trial_days > 0): ?>
                                                            <div class="d-flex justify-content-between">
                                                                <small class="text-muted"
                                                                    <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 30px" <?php endif; ?>>
                                                                    <?php echo e(__('messages.subscription.trial_plan') . ' (' . $plan->trial_days . ' ' . __('messages.plan.days') . ')'); ?>

                                                                </small>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="card-body p-3">
                                                        <div class="pricing-description text-start">
                                                            <div
                                                                class="mb-3 <?php echo e($plan->custom_select == '1' && $plan->planCustomFields->isNotEmpty() ? '' : 'pb-5'); ?>">
                                                                <?php if($plan->custom_select == 1 && $plan->planCustomFields->isNotEmpty()): ?>
                                                                    <div class="d-flex justify-content-between mb-4">
                                                                        <small class="text-muted"
                                                                            <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 30px" <?php endif; ?>>
                                                                            <?php echo e(__('messages.plan.no_of_vcard_templates')); ?>

                                                                        </small>
                                                                        <select id="vcardNumberSelect-<?php echo e($plan->id); ?>"
                                                                            class="form-select vcard-numbers"
                                                                            style="width: auto;"
                                                                            data-plan-id="<?php echo e($plan->id); ?>">
                                                                            <?php $__currentLoopData = $plan->planCustomFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <?php
                                                                                    $formattedPrice = currencyFormat(
                                                                                        $customField->custom_vcard_price,
                                                                                        2,
                                                                                        $plan->currency->currency_code,
                                                                                    );
                                                                                ?>
                                                                                <option value="<?php echo e($customField->id); ?>"
                                                                                    data-price="<?php echo e($formattedPrice); ?>"
                                                                                    data-currency="<?php echo e($plan->currency->currency_code); ?>">
                                                                                    <?php echo e($customField->custom_vcard_number); ?>

                                                                                </option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    </div>
                                                                <?php else: ?>
                                                                    <small class="text-muted"
                                                                        <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 290px" <?php endif; ?>>
                                                                        <?php echo e(__('messages.plan.no_of_vcard_templates') . ' : ' . $plan->no_of_vcards); ?>

                                                                    </small>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="mb-6">
                                                                <small class="text-muted"
                                                                    <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 320px" <?php endif; ?>>
                                                                    <?php echo e(__('messages.plan.storage_limit') . ' : ' . $plan->storage_limit . ' MB'); ?></small>
                                                            </div>
                                                            <?php $__currentLoopData = getPlanFeature($plan); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="d-flex justify-content-between mb-4">
                                                                    <p class="fw-normal">
                                                                        <?php echo e(__('messages.feature.' . $feature)); ?>

                                                                    </p>
                                                                    <?php if($value): ?>
                                                                        <i class="fa-solid fa-circle-check fs-2"></i>
                                                                    <?php else: ?>
                                                                        <i class="fa-solid fa-circle-xmark fs-2"></i>
                                                                    <?php endif; ?>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                    <div class="flex-center flex-row-fluid pt-5">
                                                        <?php if(
                                                            !empty(getCurrentSubscription()) &&
                                                                $plan->id == getCurrentSubscription()->plan_id &&
                                                                !getCurrentSubscription()->isExpired()): ?>
                                                            <?php if($plan->price != 0 || (($plan->price == 0 || $plan->price != 0) && $plan->trial_days > 0)): ?>
                                                                <button type="button"
                                                                    class="btn btn-success rounded-pill mx-auto d-block cursor-remove-plan pricing-plan-button-active"
                                                                    data-id="<?php echo e($plan->id); ?>">
                                                                    <?php echo e(__('messages.subscription.currently_active')); ?></button>
                                                            <?php else: ?>
                                                                <button type="button"
                                                                    class="btn btn-info rounded-pill mx-auto d-block cursor-remove-plan">
                                                                    <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                </button>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <?php if(
                                                                !empty(getCurrentSubscription()) &&
                                                                    !getCurrentSubscription()->isExpired() &&
                                                                    ($plan->price == 0 || $plan->price != 0)): ?>
                                                                <?php if($plan->hasZeroPlan->count() == 0 && ($plan->price > 0 || $plan->trial_days > 0)): ?>
                                                                    <a data-turbo="false"
                                                                        href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                        class="btn btn-primary rounded-pill mx-auto <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                        id="planId<?php echo e($plan->id); ?>"
                                                                        data-id="<?php echo e($plan->id); ?>"
                                                                        data-plan-price="<?php echo e($plan->price); ?>">
                                                                        <?php echo e(__('messages.subscription.switch_plan')); ?></a>
                                                                <?php else: ?>
                                                                    <?php if($plan->price == 0 && $plan->trial_days > 0): ?>
                                                                        <a data-turbo="false"
                                                                            href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                            class="btn btn-primary rounded-pill mx-auto <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                            id="planId<?php echo e($plan->id); ?>"
                                                                            data-id="<?php echo e($plan->id); ?>"
                                                                            data-plan-price="<?php echo e($plan->price); ?>">
                                                                            <?php echo e(__('messages.subscription.switch_plan')); ?></a>
                                                                    <?php else: ?>
                                                                        <button type="button"
                                                                            class="btn btn-info rounded-pill mx-auto d-block cursor-remove-plan">
                                                                            <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                        </button>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php else: ?>
                                                                <?php if(($plan->price != 0 && $plan->hasZeroPlan->count() == 0) || ($plan->price == 0 && $plan->trial_days > 0)): ?>
                                                                    <a data-turbo="false"
                                                                        href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                        class="btn btn-primary rounded-pill mx-auto <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                        id="planId<?php echo e($plan->id); ?>"
                                                                        data-id="<?php echo e($plan->id); ?>"
                                                                        data-plan-price="<?php echo e($plan->price); ?>">
                                                                        <?php echo e(__('messages.subscription.choose_plan')); ?></a>
                                                                <?php else: ?>
                                                                    <button type="button"
                                                                        class="btn btn-info rounded-pill mx-auto d-block cursor-remove-plan">
                                                                        <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                    </button>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="not-plan">
                                                <span
                                                    class="text-muted h1"><?php echo e(__('messages.subscription.no_plan_available')); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if($unLimitedPlans->isNotEmpty()): ?>
                                <div class="tab-pane <?php echo e($activeTab == 'unlimited' ? 'show active' : ''); ?>"
                                    id="unlimited">
                                    <div class="row justify-content-center">
                                        <?php $__empty_1 = true; $__currentLoopData = $unLimitedPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <?php
                                                if (
                                                    $plan->custom_select == 1 &&
                                                    $plan->planCustomFields->isNotEmpty()
                                                ) {
                                                    $plan->price = $plan->planCustomFields[0]->custom_vcard_price;
                                                }
                                            ?>
                                            <div class="col-xl-4 col-lg-5 col-md-5 col-sm-6">
                                                <div class="card pricing-card bg-light p-5 shadow-lg mb-8">
                                                    <h1><?php echo $plan->name; ?></h1>
                                                    <?php if($plan->custom_select == 1 && $plan->planCustomFields->isNotEmpty()): ?>
                                                        <h1 class="pricing-amount priceDisplayclass" id="priceDisplay">
                                                            <span
                                                                id="currentPrice-<?php echo e($plan->id); ?>"><?php echo e(currencyFormat($plan->planCustomFields[0]->custom_vcard_price, 2, $plan->currency->currency_code)); ?></span>
                                                        </h1>
                                                    <?php else: ?>
                                                        <h1 class="pricing-amount">
                                                            <?php echo e(currencyFormat($plan->price, 2, $plan->currency->currency_code)); ?>

                                                        </h1>
                                                    <?php endif; ?>
                                                    <div class="card-body ps-3 pe-3 pb-0 pt-1 ">
                                                        <?php if($plan->trial_days > 0): ?>
                                                            <div class="d-flex justify-content-between">
                                                                <small class="text-muted"
                                                                    <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 30px" <?php endif; ?>>
                                                                    <?php echo e(__('messages.subscription.trial_plan') . ' (' . $plan->trial_days . ' ' . __('messages.plan.days') . ')'); ?>

                                                                </small>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="card-body p-3">
                                                        <div class="pricing-description text-start">
                                                            <div
                                                                class="mb-3 <?php echo e($plan->custom_select == '1' && $plan->planCustomFields->isNotEmpty() ? '' : 'pb-5'); ?>">
                                                                <?php if($plan->custom_select == 1 && $plan->planCustomFields->isNotEmpty()): ?>
                                                                    <div class="d-flex justify-content-between mb-4">
                                                                        <small class="text-muted"
                                                                            <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 30px" <?php endif; ?>>
                                                                            <?php echo e(__('messages.plan.no_of_vcard_templates')); ?>

                                                                        </small>
                                                                        <select id="vcardNumberSelect-<?php echo e($plan->id); ?>"
                                                                            class="form-select vcard-numbers"
                                                                            style="width: auto;"
                                                                            data-plan-id="<?php echo e($plan->id); ?>">
                                                                            <?php $__currentLoopData = $plan->planCustomFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <?php
                                                                                    $formattedPrice = currencyFormat(
                                                                                        $customField->custom_vcard_price,
                                                                                        2,
                                                                                        $plan->currency->currency_code,
                                                                                    );
                                                                                ?>
                                                                                <option value="<?php echo e($customField->id); ?>"
                                                                                    data-price="<?php echo e($formattedPrice); ?>"
                                                                                    data-currency="<?php echo e($plan->currency->currency_code); ?>">
                                                                                    <?php echo e($customField->custom_vcard_number); ?>

                                                                                </option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    </div>
                                                                <?php else: ?>
                                                                    <small class="text-muted"
                                                                        <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 290px" <?php endif; ?>>
                                                                        <?php echo e(__('messages.plan.no_of_vcard_templates') . ' : ' . $plan->no_of_vcards); ?>

                                                                    </small>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="mb-6">
                                                                <small class="text-muted"
                                                                    <?php if(getLogInUser()->language == 'ar' || getLogInUser()->language == 'fa'): ?> style="margin-left: 320px" <?php endif; ?>>
                                                                    <?php echo e(__('messages.plan.storage_limit') . ' : ' . $plan->storage_limit . ' MB'); ?></small>
                                                            </div>
                                                            <?php $__currentLoopData = getPlanFeature($plan); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="d-flex justify-content-between mb-4">
                                                                    <p class="fw-normal">
                                                                        <?php echo e(__('messages.feature.' . $feature)); ?></p>
                                                                    <?php if($value): ?>
                                                                        <i class="fa-solid fa-circle-check fs-2"></i>
                                                                    <?php else: ?>
                                                                        <i class="fa-solid fa-circle-xmark fs-2"></i>
                                                                    <?php endif; ?>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                    <div class="flex-center flex-row-fluid pt-5">
                                                        <?php if(
                                                            !empty(getCurrentSubscription()) &&
                                                                $plan->id == getCurrentSubscription()->plan_id &&
                                                                !getCurrentSubscription()->isExpired()): ?>
                                                            <?php if($plan->price != 0 || (($plan->price == 0 || $plan->price != 0) && $plan->trial_days > 0)): ?>
                                                                <button type="button"
                                                                    class="btn btn-success rounded-pill mx-auto d-block cursor-remove-plan pricing-plan-button-active"
                                                                    data-id="<?php echo e($plan->id); ?>">
                                                                    <?php echo e(__('messages.subscription.currently_active')); ?></button>
                                                            <?php else: ?>
                                                                <button type="button"
                                                                    class="btn btn-info rounded-pill mx-auto d-block cursor-remove-plan">
                                                                    <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                </button>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <?php if(
                                                                !empty(getCurrentSubscription()) &&
                                                                    !getCurrentSubscription()->isExpired() &&
                                                                    ($plan->price == 0 || $plan->price != 0)): ?>
                                                                <?php if($plan->hasZeroPlan->count() == 0 && ($plan->price > 0 || $plan->trial_days > 0)): ?>
                                                                    <a data-turbo="false"
                                                                        href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                        class="btn btn-primary rounded-pill mx-auto <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                        id="planId<?php echo e($plan->id); ?>"
                                                                        data-id="<?php echo e($plan->id); ?>"
                                                                        data-plan-price="<?php echo e($plan->price); ?>">
                                                                        <?php echo e(__('messages.subscription.switch_plan')); ?></a>
                                                                <?php else: ?>
                                                                    <?php if($plan->price == 0 && $plan->trial_days > 0): ?>
                                                                        <a data-turbo="false"
                                                                            href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                            class="btn btn-primary rounded-pill mx-auto <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                            id="planId<?php echo e($plan->id); ?>"
                                                                            data-id="<?php echo e($plan->id); ?>"
                                                                            data-plan-price="<?php echo e($plan->price); ?>">
                                                                            <?php echo e(__('messages.subscription.switch_plan')); ?></a>
                                                                    <?php else: ?>
                                                                        <button type="button"
                                                                            class="btn btn-info rounded-pill mx-auto d-block cursor-remove-plan">
                                                                            <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                        </button>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php else: ?>
                                                                <?php if(($plan->price != 0 && $plan->hasZeroPlan->count() == 0) || ($plan->price == 0 && $plan->trial_days > 0)): ?>
                                                                    <a data-turbo="false"
                                                                        href="<?php echo e($plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)'); ?>"
                                                                        class="btn btn-primary rounded-pill mx-auto <?php echo e($plan->price == 0 ? 'freePayment' : ''); ?>"
                                                                        data-id="<?php echo e($plan->id); ?>"
                                                                        id="planId<?php echo e($plan->id); ?>"
                                                                        data-plan-price="<?php echo e($plan->price); ?>">
                                                                        <?php echo e(__('messages.subscription.choose_plan')); ?></a>
                                                                <?php else: ?>
                                                                    <button type="button"
                                                                        class="btn btn-info rounded-pill mx-auto d-block cursor-remove-plan">
                                                                        <?php echo e(__('messages.subscription.renew_free_plan')); ?>

                                                                    </button>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="not-plan">
                                                <span
                                                    class="text-muted h1"><?php echo e(__('messages.subscription.no_plan_available')); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yippvslhxp/cards.jaaftek.com/resources/views/subscription/upgrade.blade.php ENDPATH**/ ?>