<div class="modal fade" id="editServiceModal" tabindex="-1" aria-modal="true" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title"><?php echo e(__('messages.vcard.edit_service')); ?></h2>
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php echo Form::open(['id'=>'editServiceForm', 'files' => 'true']); ?>

                <div class="row">
                    <div class="col-sm-12 mb-5">
                        <?php echo e(Form::hidden('service_id', null,['id' => 'serviceId'])); ?>

                        <?php echo e(Form::label('name',__('messages.common.name').(':'), ['class' => 'form-label required fs-6  text-gray-700 mb-3'])); ?>

                        <?php echo e(Form::text('name', null, ['class' => 'form-control', 'id' => 'editName', 'required', 'placeholder' => __('messages.form.service')])); ?>

                    </div>
                    <div class="mb-5">
                        <?php echo e(Form::label('service_url', __('messages.common.service_url').':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::text('service_url', null, ['class' => 'form-control', 'id' => 'editServiceURL', 'placeholder' => __('messages.common.service_url')])); ?>

                    </div>
                    <div class="col-sm-12 mb-5">
                        <?php echo e(Form::label('description', __('messages.common.description').':', ['class' => 'form-label required fs-6 text-gray-700 mb-3'])); ?>

                        <?php echo e(Form::textarea('description', null, ['class' => 'form-control', 'id' => 'editDescription', 'placeholder' =>__('messages.form.short_description'), 'rows' => '5' , 'required'])); ?>

                    </div>
                    <div class="col-sm-12 mb-5">

                        <div class="mb-3" io-image-input="true">
                            <label for="editServicePreview"
                                   class="form-label required"><?php echo e(__('messages.vcard.service_icon').':'); ?></label>
                            <span data-bs-toggle="tooltip" data-placement="top"
                                data-bs-original-title="<?php echo e(__('messages.tooltip.vcard_defaut_img')); ?>">
                                <i class="fas fa-question-circle ml-1 general-question-mark"></i>
                            </span>
                            <div class="d-block">
                                <div class="image-picker">
                                    <div class="image previewImage" id="editServicePreview"
                                         style="background-image: url(<?php echo e(asset('assets/images/default_service.png')); ?>)"></div>
                                    <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip"
                                          data-placement="top" data-bs-original-title="<?php echo e(__('messages.tooltip.change_service_icon')); ?>">
                                        <label>
                                        <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                            <input type="file" id="editServiceIcon" name="service_icon"
                                                   class="image-upload file-validation d-none crop-image-input" data-aspect-ratio="1" accept="image/*" data-preview-id="editServicePreview"/>
                                        </label>
                                    </span>
                                </div>
                                <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex">
                        <?php echo e(Form::button(__('messages.common.save'), ['type'=>'submit','class' => 'btn btn-primary me-3','id'=>'serviceUpdate'])); ?>

                        <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal"><?php echo e(__('messages.common.discard')); ?></button>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/yippvslhxp/cards.jaaftek.com/resources/views/vcards/services/edit.blade.php ENDPATH**/ ?>