<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title> <?php echo e(__('messages.blog.blogs')); ?> | <?php echo e(getAppName()); ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css"
        integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="icon" href="<?php echo e(getFaviconUrl()); ?>" type="image/png">
    
    <link href="<?php echo e(asset('front/css/bootstrap.min.css')); ?>" rel="stylesheet">
    
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/slider/css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/slider/css/slick-theme.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('assets/css/new_home/layout.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('assets/css/new_home/custom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('assets/css/blogs/blogs.css')); ?>">
    <style>
        .accordion-button::after {
            background-image: url('img/Vector.png') !important;
        }

        .accordion-button:not(.collapsed)::after {
            background-image: url('img/Vector2.png') !important;
            height: 5px !important;
        }
    </style>
    <?php if(!empty($setting['custom_css'])): ?>
    <style>
            <?php echo $setting['custom_css']; ?>

    </style>
    <?php endif; ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendor/rappasoft/livewire-tables/css/laravel-livewire-tables.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendor/rappasoft/livewire-tables/css/laravel-livewire-tables-thirdparty.min.css')); ?>">
</head>

<body>
    <div class="vcard-object object-img-1">
        <img src="<?php echo e(asset('/assets/img/new_home_page/object-1.png')); ?>" alt="image">
    </div>
    <div class="vcard-object object-img-2">
        <img src="<?php echo e(asset('/assets/img/new_home_page/object-2.png')); ?>" alt="image">
    </div>
    <div class="vcard-object object-img-3">
        <img src="<?php echo e(asset('/assets/img/new_home_page/object-3.png')); ?>" alt="image">
    </div>
    <div class="vcard-object object-img-4">
        <img src="<?php echo e(asset('/assets/img/new_home_page/object-4.png')); ?>" alt="image">
    </div>
    <div class="vcard-object object-img-5">
        <img src="<?php echo e(asset('/assets/img/new_home_page/object-5.png')); ?>" alt="image">
    </div>
    <div class="vcard-object object-img-6">
        <img src="<?php echo e(asset('/assets/img/new_home_page/object-6.png')); ?>" alt="image">
    </div>
    <div class="vcard-object object-img-7">
        <img src="<?php echo e(asset('/assets/img/new_home_page/object-7.png')); ?>" alt="image">
    </div>
    <div class="vcard-object subscribeBtn">
        <img src="<?php echo e(asset('/assets/img/new_home_page/object-8.png')); ?>" alt="image">
    </div>
    <!-- start header section -->
    <header class="header" <?php if(checkFrontLanguageSession() == 'ar' || checkFrontLanguageSession() == 'fa'): ?> dir="rtl" <?php endif; ?>>
        <div class="container">
            <div class="row align-items-center justify-content-between">
                <div class="col-lg-2 col-sm-8 col-5 order-lg-1 order-0">
                    <a class="navbar-brand p-0" href="<?php echo e(url('/')); ?>">
                        <img src="<?php echo e(getLogoUrl()); ?>" alt="company-logo" class="w-auto h-100" />
                    </a>
                </div>
                <div class="col-lg-10 col-sm-1 col-2 order-lg-1 order-2">
                    <nav class="navbar navbar-expand-lg navbar-light justify-content-end">
                        <div class="navbar-toggler mt-2" type="button" data-bs-toggle="collapse"
                            data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false"
                            aria-label="Toggle navigation" id="toogler-icon">
                            <span class="navbar-toggler-icon top-bar"></span>
                            <span class="navbar-toggler-icon middle-bar"></span>
                            <span class="navbar-toggler-icon bottom-bar"></span>
                        </div>
                        <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                            <ul class="navbar-nav align-items-lg-center">
                                <li class="nav-item">
                                    <a class="nav-link active nav-link-white" aria-current="page"
                                        href="<?php echo e(asset('') . '#frontHomeTab'); ?>"
                                        data-turbo="false"><?php echo e(__('auth.home')); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link nav-link-white" href="<?php echo e(asset('') . '#frontAboutTabUsTab'); ?>"
                                        data-turbo="false"><?php echo e(__('auth.about')); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link nav-link-white" href="<?php echo e(asset('') . '#frontPricingTab'); ?>"
                                        data-turbo="false"><?php echo e(__('auth.pricing')); ?></a>
                                </li>

                                <li class="nav-item px-3">
                                    <a class="nav-link nav-link-white"
                                        href="<?php echo e(route('fornt-blog')); ?>"><?php echo e(__('messages.blog.blogs')); ?></a>
                                </li>

                                <li class="nav-item <?php if($faqs === null): ?> d-none <?php endif; ?>">
                                    <a class="nav-link nav-link-white"
                                        href="<?php echo e(route('fornt-faq')); ?>"><?php echo e(__('messages.faqs.faqs')); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link nav-link-white" href="<?php echo e(asset('') . '#frontContactUsTab'); ?>"
                                        data-turbo="false"><?php echo e(__('auth.contact')); ?> </a>
                                </li>
                                <li class="nav-item">
                                    <div class="dropdown">
                                        <a class="btn dropdown-toggle nav-link-white" href="#" role="button"
                                            id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false"
                                            data-turbo="false">
                                            <?php echo e(__('messages.language')); ?></a>
                                        <ul class="dropdown-menu p-2" aria-labelledby="dropdownMenuLink">
                                            <?php $__currentLoopData = getAllLanguageWithFullData(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="languageSelection <?php echo e(checkFrontLanguageSession() == $key ? 'active' : ''); ?>"
                                                    data-prefix-value="<?php echo e($language->iso_code); ?>">
                                                    <a href="javascript:void(0)"
                                                        class="nav-link d-flex align-items-center dropdown-item <?php echo e(checkFrontLanguageSession() == $key ? 'active' : ''); ?>">
                                                        <?php if(array_key_exists($language->iso_code, \App\Models\User::FLAG)): ?>
                                                            <?php $__currentLoopData = \App\Models\User::FLAG; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imageKey => $imageValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($imageKey == $language->iso_code): ?>
                                                                    <img src="<?php echo e(asset($imageValue)); ?>"
                                                                        class="me-1" />
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <?php if(count($language->media) != 0): ?>
                                                                <img src="<?php echo e($language->image_url); ?>"
                                                                    class="me-1" />
                                                            <?php else: ?>
                                                                <i class="fa fa-flag fa-xl me-3 text-danger"
                                                                    aria-hidden="true"></i>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                        <?php echo e($language->name); ?>

                                                    </a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </li>
                                <?php if(empty(getLogInUser())): ?>
                                    <a class="btn btn-white text-decoration-none fs-18 sign-in-btn d-lg-block d-none d-lg-block d-none"
                                        href="<?php echo e(route('login')); ?>" data-turbo="false">
                                        <?php echo e(__('auth.sign_in')); ?>

                                    </a>
                                <?php else: ?>
                                    <?php if(getLogInUser()->hasrole('admin') || getLogInUser()->hasrole('user')): ?>
                                        <a class="btn btn-white text-decoration-none fs-18 sign-in-btn d-lg-block d-none"
                                            href="<?php echo e(route('admin.dashboard')); ?>" data-turbo="false">
                                            <?php echo e(__('messages.dashboard')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if(getLogInUser()->hasrole('super_admin')): ?>
                                        <a class="btn btn-white text-decoration-none fs-18 d-lg-block d-none"
                                            href="<?php echo e(route('sadmin.dashboard')); ?>" data-turbo="false">
                                            <?php echo e(__('messages.dashboard')); ?>

                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </nav>
                </div>
                <div class="col-lg-2 col-sm-3 col-5 text-end order-lg-2 order-1 pe-lg-2 pe-0 d-lg-none">
                    <?php if(empty(getLogInUser())): ?>
                        <a class="btn btn-white fs-18 me-sm-2" href="<?php echo e(route('login')); ?>" data-turbo="false">
                            <?php echo e(__('auth.sign_in')); ?>

                        </a>
                    <?php else: ?>
                        <?php if(getLogInUser()->hasrole('admin') || getLogInUser()->hasrole('user')): ?>
                            <a class="btn btn-white fs-18 me-sm-2" href="<?php echo e(route('admin.dashboard')); ?>"
                                data-turbo="false">
                                <?php echo e(__('messages.dashboard')); ?>

                            </a>
                        <?php endif; ?>
                        <?php if(getLogInUser()->hasrole('super_admin')): ?>
                            <a class="btn btn-white fs-18 me-sm-2" href="<?php echo e(route('sadmin.dashboard')); ?>"
                                data-turbo="false">
                                <?php echo e(__('messages.dashboard')); ?>

                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </header>
    <!-- end header section -->

    <!-- start hero section -->
    <section class="hero-section bg-primary pt-100 pb-60">
        <div class="container pt-60 mt-3">
            <div class="row">
                <div class="col-12 text-center">
                    <h2 class="fs-40 text-white"> <?php echo e(__('messages.blog.blogs')); ?> </h2>
                </div>
            </div>
        </div>
    </section>
    <!-- end hero section -->

    <!--start Blogs-section -->
    <section class="about-section overflow-hidden padding-t-100px py-5" id=""
        <?php if(checkFrontLanguageSession() == 'ar' || checkFrontLanguageSession() == 'fa'): ?> dir="rtl" <?php endif; ?>>
        <div class="container">
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('blog-list');

$__html = app('livewire')->mount($__name, $__params, 'lw-3140285613-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>
    </section>
    <!-- end Blogs-section -->

    <!-- start footer section -->
    <div class="curve-shape">
        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px"
            y="0px" viewBox="0 0 4000 275">
            <path fill="#f3f3ff" d="M4000,125.3V275H0V109.9C1907.2,615.4,2670.5-323.1,4000,125.3z"></path>
        </svg>
    </div>
    <?php if(checkFrontLanguageSession() != 'ar' && checkFrontLanguageSession() != 'fa'): ?>
        <footer class="bg-light">
            <div class="container">
                <div class="row align-items-center flex-lg-row flex-column-reverse pt-50 pb-40">
                    <div class="col-lg-6">
                        <div class="text-lg-start text-center pe-xxl-5 me-xxl-5">
                            <h3 class="fs-30 mb-20"><?php echo e(__('messages.Subscribe_Our_Newsletter')); ?></h3>
                            <p class="text-gray-100 fs-18 mb-40 pb-lg-3 pe-xl-5 me-xl-5">
                                <?php echo e(__('messages.Receive_latest_news_update_and_many_other_things_every_week')); ?></p>
                        </div>
                        <form action="<?php echo e(route('email.sub')); ?>" method="post" id="addEmail">
                            <?php echo csrf_field(); ?>
                            <div class="email">
                                <input type="email" name="email" class="form-control"
                                    placeholder="<?php echo e(__('messages.front.enter_your_email')); ?>" required>
                                <div class=" subscribe-btn text-sm-end text-center mt-sm-0 mt-4">
                                    <button type="submit"
                                        class="btn btn-primary h-100 subscribeBtn"><?php echo e(__('messages.subscribe')); ?></button>
                                </div>
                            </div>
                        </form>
                        <div class="main-social-links my-3">
                            <?php if(isset($setting['website_link']) && !empty($setting['website_link'])): ?>
                                <a class="globe" href="<?php echo e($setting['website_link']); ?>"><i
                                        class="fas fa-globe"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['twitter_link']) && !empty($setting['twitter_link'])): ?>
                                <a class="twitter" href="<?php echo e($setting['twitter_link']); ?>">
                                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                                        width="19px" height="19px">
                                        <path
                                            d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z" />
                                    </svg>
                                </a>
                            <?php endif; ?>
                            <?php if(isset($setting['facebook_link']) && !empty($setting['facebook_link'])): ?>
                                <a class="facebook" href="<?php echo e($setting['facebook_link']); ?>"><i
                                        class="fab fa-facebook-square"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['instagram_link']) && !empty($setting['instagram_link'])): ?>
                                <a class="instagram" href="<?php echo e($setting['instagram_link']); ?>"><i
                                        class="fab fa-instagram"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['youtube_link']) && !empty($setting['youtube_link'])): ?>
                                <a class="youtube" href="<?php echo e($setting['youtube_link']); ?>"><i
                                        class="fab fa-youtube"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['tumbir_link']) && !empty($setting['tumbir_link'])): ?>
                                <a class="tumblr" href="<?php echo e($setting['tumbir_link']); ?>"><i
                                        class="fab fa-tumblr-square"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['reddit_link']) && !empty($setting['reddit_link'])): ?>
                                <a class="reddit" href="<?php echo e($setting['reddit_link']); ?>"><i
                                        class="fab fa-reddit-alien"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['linkedin_link']) && !empty($setting['linkedin_link'])): ?>
                                <a class="linkedin" href="<?php echo e($setting['linkedin_link']); ?>"><i
                                        class="fab fa-linkedin"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['whatsapp_link']) && !empty($setting['whatsapp_link'])): ?>
                                <a class="whatsapp" href="<?php echo e($setting['whatsapp_link']); ?>"><i
                                        class="fab fa-whatsapp"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['pinterest_link']) && !empty($setting['pinterest_link'])): ?>
                                <a class="pinterest" href="<?php echo e($setting['pinterest_link']); ?>"><i
                                        class="fab fa-pinterest"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['tiktok_link']) && !empty($setting['tiktok_link'])): ?>
                                <a class="tiktok" href="<?php echo e($setting['tiktok_link']); ?>"><i
                                        class="fab fa-tiktok"></i></a>
                            <?php endif; ?>
                        </div>
                    
                    <?php if(isset($customPageAll) && $customPageAll && count($customPageAll) > 0): ?>
                        <div class="row pt-3 mb-3">
                            <div class="col-12">
                                <div class="d-flex flex-wrap gap-1" style="gap: 0.25rem !important;">
                                    <?php $__currentLoopData = $customPageAll; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-1">
                                            <a href="<?php echo e(route('fornt-custom-page-show', $page->slug)); ?>"
                                               class="text-muted text-decoration-none small px-2 py-1 rounded d-inline-block">
                                                <?php echo e($page->title); ?>

                                            </a>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    </div>
                    <div class="col-lg-6 text-lg-end text-center mb-lg-0 mb-40">
                        <div class="footer-img ">
                            <img src="<?php echo e(asset('assets/img/new_home_page/footer-img.png')); ?>"
                                class="zoom-in-zoom-out img-fluid w-auto h-100" alt="img">
                        </div>
                    </div>
                </div>
                <div class="row align-items-center pb-md-4 pb-3">
                    <div class="col-md-7 text-md-start text-center mb-md-0 mb-2">
                        <p class="text-black fw-light mb-0">
                            © <?php echo e(\Carbon\Carbon::now()->year); ?> <?php echo e(__('auth.copyright_by') . ' '); ?><span
                                class="fw-6"><?php echo e($setting['app_name']); ?></span>
                        </p>
                    </div>
                    <div class="col-md-5 text-md-end">
                        <div class="d-flex justify-content-md-end justify-content-center">
                            <a href="<?php echo e(route('terms.conditions')); ?>"
                                class="text-black text-decoration-none me-4"><?php echo __('messages.vcard.term_condition'); ?></a>
                            <a href="<?php echo e(route('privacy.policy')); ?>"
                                class="text-black text-decoration-none"><?php echo e(__('messages.vcard.privacy_policy')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </footer>
    <?php else: ?>
        <footer class="bg-light" dir="rtl">
            <div class="container">
                <div class="row align-items-center flex-lg-row flex-column-reverse pt-50 pb-40">
                    <div class="col-lg-6">
                        <div class="text-lg-end text-center pe-xxl-5 me-xxl-5">
                            <h3 class="fs-30 mb-20"><?php echo e(__('messages.Subscribe_Our_Newsletter')); ?></h3>
                            <p class="text-gray-100 fs-18 mb-40 pb-lg-3 text-end">
                                <?php echo e(__('messages.Receive_latest_news_update_and_many_other_things_every_week')); ?></p>
                        </div>
                        <form action="<?php echo e(route('email.sub')); ?>" method="post" id="addEmail">
                            <?php echo csrf_field(); ?>
                            <div class="email">
                                <input type="email" name="email" class="form-control"
                                    placeholder="<?php echo e(__('messages.front.enter_your_email')); ?>" required>
                                <div class=" subscribe-btn text-sm-end text-center mt-sm-0 mt-4">
                                    <button type="submit"
                                        class="btn btn-primary h-100 subscribeBtn"><?php echo e(__('messages.subscribe')); ?></button>
                                </div>
                            </div>
                        </form>
                        <div class="main-social-links my-3">
                            <?php if(isset($setting['website_link']) && !empty($setting['website_link'])): ?>
                                <a class="globe" href="<?php echo e($setting['website_link']); ?>"><i
                                        class="fas fa-globe"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['twitter_link']) && !empty($setting['twitter_link'])): ?>
                                <a class="twitter" href="<?php echo e($setting['twitter_link']); ?>">
                                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                                        width="19px" height="19px">
                                        <path
                                            d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z" />
                                    </svg>
                                </a>
                            <?php endif; ?>
                            <?php if(isset($setting['facebook_link']) && !empty($setting['facebook_link'])): ?>
                                <a class="facebook" href="<?php echo e($setting['facebook_link']); ?>"><i
                                        class="fab fa-facebook-square"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['instagram_link']) && !empty($setting['instagram_link'])): ?>
                                <a class="instagram" href="<?php echo e($setting['instagram_link']); ?>"><i
                                        class="fab fa-instagram"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['youtube_link']) && !empty($setting['youtube_link'])): ?>
                                <a class="youtube" href="<?php echo e($setting['youtube_link']); ?>"><i
                                        class="fab fa-youtube"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['tumbir_link']) && !empty($setting['tumbir_link'])): ?>
                                <a class="tumblr" href="<?php echo e($setting['tumbir_link']); ?>"><i
                                        class="fab fa-tumblr-square"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['reddit_link']) && !empty($setting['reddit_link'])): ?>
                                <a class="reddit" href="<?php echo e($setting['reddit_link']); ?>"><i
                                        class="fab fa-reddit-alien"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['linkedin_link']) && !empty($setting['linkedin_link'])): ?>
                                <a class="linkedin" href="<?php echo e($setting['linkedin_link']); ?>"><i
                                        class="fab fa-linkedin"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['whatsapp_link']) && !empty($setting['whatsapp_link'])): ?>
                                <a class="whatsapp" href="<?php echo e($setting['whatsapp_link']); ?>"><i
                                        class="fab fa-whatsapp"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['pinterest_link']) && !empty($setting['pinterest_link'])): ?>
                                <a class="pinterest" href="<?php echo e($setting['pinterest_link']); ?>"><i
                                        class="fab fa-pinterest"></i></a>
                            <?php endif; ?>
                            <?php if(isset($setting['tiktok_link']) && !empty($setting['tiktok_link'])): ?>
                                <a class="tiktok" href="<?php echo e($setting['tiktok_link']); ?>"><i
                                        class="fab fa-tiktok"></i></a>
                            <?php endif; ?>
                        </div>
                        <?php if(isset($customPageAll) && $customPageAll && count($customPageAll) > 0): ?>
                            <div class="pt-3 mb-3">
                                <div class="d-flex flex-wrap gap-1" style="gap: 0.25rem !important;">
                                    <?php $__currentLoopData = $customPageAll; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-1">
                                            <a href="<?php echo e(route('fornt-custom-page-show', $page->slug)); ?>"
                                               class="text-muted text-decoration-none small px-2 py-1 rounded d-inline-block">
                                                <?php echo e($page->title); ?>

                                            </a>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                    <div class="col-lg-6 text-lg-start text-center mb-lg-0 mb-40">
                        <div class="footer-img ">
                            <img src="<?php echo e(asset('assets/img/new_home_page/footer-img.png')); ?>"
                                class="zoom-in-zoom-out img-fluid w-auto h-100" alt="img">
                        </div>
                    </div>
                </div>
                <div class="row align-items-center pb-md-4 pb-3">
                    <div class="col-md-7 text-md-end text-center mb-md-0 mb-2">
                        <p class="text-black fw-light mb-0">
                            © <?php echo e(\Carbon\Carbon::now()->year); ?> <?php echo e(__('auth.copyright_by') . ' '); ?><span
                                class="fw-6"><?php echo e($setting['app_name']); ?></span>
                        </p>
                    </div>
                    <div class="col-md-5 text-md-end">
                        <div class="d-flex justify-content-md-end justify-content-center">
                            <a href="<?php echo e(route('terms.conditions')); ?>"
                                class="text-black text-decoration-none me-4"><?php echo __('messages.vcard.term_condition'); ?></a>
                            <a href="<?php echo e(route('privacy.policy')); ?>"
                                class="text-black text-decoration-none"><?php echo e(__('messages.vcard.privacy_policy')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </footer>
    <?php endif; ?>
    <!-- end footer section -->
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <script src="<?php echo e(asset('vendor/rappasoft/livewire-tables/js/laravel-livewire-tables.min.js')); ?>"></script>
	<script src="<?php echo e(asset('vendor/rappasoft/livewire-tables/js/laravel-livewire-tables-thirdparty.min.js')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/front-third-party.js')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/front-pages.js')); ?>"></script>
    <script>
        $("#toogler-icon").click(function() {
            $(this).toggleClass("open");
        });
    </script>
</body>

</html>
<?php /**PATH /home/yippvslhxp/cards.jaaftek.com/resources/views/front/home/home-blog1.blade.php ENDPATH**/ ?>