<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" href="<?php echo e(getFaviconUrl()); ?>" type="image/png">
    <?php if(!empty($metas)): ?>
        <?php if($metas['meta_description']): ?>
            <meta name="description" content="<?php echo e($metas['meta_description']); ?>">
        <?php endif; ?>
        <?php if($metas['meta_keyword']): ?>
            <meta name="keywords" content="<?php echo e($metas['meta_keyword']); ?>">
        <?php endif; ?>
        <?php if($metas['home_title'] && $metas['site_title']): ?>
            <title><?php echo e($metas['home_title']); ?> | <?php echo e($metas['site_title']); ?></title>
        <?php else: ?>
            <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(getAppName()); ?></title>
        <?php endif; ?>
    <?php else: ?>
        <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(getAppName()); ?></title>
        <meta name="description" content="">
        <meta name="keywords" content="">
    <?php endif; ?>

    <?php if(!empty(getAppLogo())): ?>
        <meta property="og:image" content="<?php echo e(getAppLogo()); ?>" />
    <?php endif; ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css"
        integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/new_home/bootstrap.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/slider/css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/slider/css/slick-theme.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('assets/css/new_home/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('assets/css/new_home/slick-theme.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('assets/css/new_home/layout.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('assets/css/new_home/custom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('assets/css/new_home/index.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/third-party.css')); ?>">
    <script src="<?php echo e(asset('messages.js?$mixID')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/front-third-party.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/third-party.js')); ?>" defer></script>
    <script type="text/javascript" src="<?php echo e(asset('front/js/bootstrap.bundle.min.js')); ?>" defer></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/slider/js/slick.min.js')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/custom/helpers.js')); ?>" defer></script>
    <script src="<?php echo e(mix('assets/js/custom/custom.js')); ?>" defer></script>


    <?php
        $langSession = Session::get('languageName');
        $frontLanguage = !isset($langSession) ? getSuperAdminSettingValue('default_language') : $langSession;
    ?>

    <script>
        let frontLanguage = "<?php echo e($frontLanguage); ?>"
        Lang.setLocale(frontLanguage)
    </script>
    <script src="<?php echo e(mix('assets/js/front-pages.js')); ?>" defer></script>

    <?php if(!empty($setting['custom_css'])): ?>
    <style>
            <?php echo $setting['custom_css']; ?>

    </style>
    <?php endif; ?>

   <?php echo getSuperAdminSettingValue('extra_js_front'); ?>


    <?php if(!empty($metas['google_analytics'])): ?>
        <!--google analytics code-->
        <?php echo $metas['google_analytics']; ?>

    <?php endif; ?>

    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>

    <script>
        $(document).ready(function() {
            if (window.location.hash) {
                // There's a hash, scroll to it
                setTimeout(function() {
                    var target = $(window.location.hash);
                    if (target.length) {
                    $('html, body').animate({
                        scrollTop: target.offset().top - 80
                    }, 1000);
                }
                }, 500);
            } else {
                // No hash, scroll to top
                $('html, body').animate({
                    scrollTop: $('html').offset().top,
                });
            }
        });
    </script>
    <script data-turbo-eval="false">
        window.getLoggedInUserLang = "<?php echo e(getCurrentLanguageName()); ?>"
        let lang = "<?php echo e(Illuminate\Support\Facades\Auth::user()->language ?? 'en'); ?>"
    </script>
</head>

<body>
    <div class="<?php if(checkFrontLanguageSession() == 'ar' || checkFrontLanguageSession() == 'fa'): ?> home1-rtl <?php endif; ?>">
        <?php echo $__env->make('front.layouts.header1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('front.layouts.footer1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <script>
        $("#toogler-icon").click(function() {
            $(this).toggleClass("open");
        });
        $('.nav-btn').on('click', function(e) {
            e.preventDefault();
            if ($(this).hasClass('open')) {
                $('.new-home-nav').removeClass('d-none')
            } else {
                $('.new-home-nav').addClass('d-none')
            }
        })
    </script>

    <script>
        $(".pricing-slider").slick({
            autoplay: true,
            autoplaySpeed: 5000,
            dots: true,
            slidesToShow: 3,
            slidesToScroll: 1,
            arrows: false,
            responsive: [{
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 2,
                        centerMode: true,
                    },
                },
                {
                    breakpoint: 991,
                    settings: {
                        slidesToShow: 1.7,
                        centerMode: true,
                    },
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 1,
                    },
                },
            ],
        });
    </script>
    <script>
        $('.center-slider').slick({
            autoplay: true,
            autoplaySpeed: 1000,
            slidesToShow: 5,
            slidesToScroll: 1,
            centerMode: true,
            arrows: true,
            dots: false,
            speed: 300,
            centerPadding: '20px',
            infinite: true,
            autoplaySpeed: 5000,
            prevArrow: '<button class="slide-arrow prev-arrow" aria-label="prev-btn"><i class="fa-solid fa-arrow-left"></i></button>',
            nextArrow: '<button class="slide-arrow next-arrow" aria-label="next-btn"><i class="fa-solid fa-arrow-right"></i></button>',
            responsive: [{
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 3,
                    },
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 1,
                    },
                },

            ],
            // autoplay: true
        });
    </script>
    <script>
        $(".feature-slider").slick({
            // autoplay: true,
            autoplaySpeed: 1000,
            speed: 600,
            draggable: true,
            infinite: true,
            dots: false,
            slidesToShow: 4,
            slidesToScroll: 1,
            arrows: true,
            prevArrow: '<button class="slide-arrow prev-arrow" aria-label="prev-btn"><i class="fa-solid fa-chevron-left"></i></button>',
            nextArrow: '<button class="slide-arrow next-arrow" aria-label="next-btn"><i class="fa-solid fa-chevron-right"></i></button>',
            responsive: [{
                    breakpoint: 1199,
                    settings: {
                        slidesToShow: 3,
                    },
                },
                {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 2,
                    },
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 1,
                    },
                },

            ],

        });
    </script>
    <script>
        $(".testimonial-slider").slick({
            autoplay: true,
            autoplaySpeed: 1000,
            speed: 600,
            draggable: true,
            infinite: true,
            dots: false,
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: true,
            prevArrow: '<button class="slide-arrow prev-arrow" aria-label="prev-btn"><i class="fa-solid fa-chevron-left"></i></button>',
            nextArrow: '<button class="slide-arrow next-arrow" aria-label="prev-btn"><i class="fa-solid fa-chevron-right"></i></button>',
        });
    </script>
</body>

</html>
<?php /**PATH /home/yippvslhxp/cards.jaaftek.com/resources/views/front/layouts/app1.blade.php ENDPATH**/ ?>